package net.odoframework.beans;

import java.util.function.Function;

import static java.util.Objects.requireNonNull;

public class TwoWayBinding<Source, SourceType, Target, TargetType> extends OneWayBinding<Source, SourceType, Target, TargetType> {

    @SuppressWarnings("unchecked")
    private Function<SourceType, TargetType> toTarget = (src) -> (TargetType) src;

    public TwoWayBinding(
            Binding<Source,SourceType> sourceBinding,
            Binding<Target,TargetType> targetBinding,
            Function<SourceType, TargetType> toTarget,
            Function<TargetType, SourceType> fromTarget) {
        super(sourceBinding, targetBinding, fromTarget);
        this.toTarget = requireNonNull(toTarget, "toTarget is a required parameter");
    }

    @SuppressWarnings("unchecked")
    public TwoWayBinding(Binding<Source,SourceType> sourceBinding, Binding<Target,TargetType> targetBinding) {
        this(sourceBinding, targetBinding, (src) -> (TargetType) src, (target) -> (SourceType) target);
    }

    public TargetType bindTo(Source source, Target target) {
        var sourceValue = sourceBinding.get(source);
        var targetValue = toTarget.apply(sourceValue);
        targetBinding.set(target, targetValue);
        return targetValue;
    }


}
