package net.odoframework.beans;

import java.util.function.Function;

import static java.util.Objects.requireNonNull;

public class OneWayBinding<Source, SourceType, Target, TargetType> {
    @SuppressWarnings("unchecked")
    protected Function<TargetType, SourceType> fromTarget;
    protected Binding<Source, SourceType> sourceBinding;
    protected Binding<Target, TargetType> targetBinding;

    public OneWayBinding(
            Binding<Source,SourceType> sourceBinding,
            Binding<Target,TargetType> targetBinding,
            Function<TargetType, SourceType> fromTarget) {
        this.fromTarget = requireNonNull(fromTarget, "fromTarget is a required parameter");
        this.sourceBinding = requireNonNull(sourceBinding, "sourceBinding is a required parameter");
        this.targetBinding = requireNonNull(targetBinding, "targetBinding is a required parameter");
    }

    public SourceType getSource(Source source) {
        return sourceBinding.get(source);
    }

    public TargetType getTarget(Target target) {
        return targetBinding.get(target);
    }

    public SourceType bindFrom(Target target, Source source) {
        var targetValue = targetBinding.get(target);
        var sourceValue = fromTarget.apply(targetValue);
        sourceBinding.set(source, sourceValue);
        return sourceValue;
    }
}
