package net.odoframework.beans;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MapToObjectRegistry {

    private final Map<Class<?>, ObjectToMap<?>> registry;


    public MapToObjectRegistry() {
        registry = new HashMap<>();
    }

    @SuppressWarnings("unchecked")
    public <T> Optional<ObjectToMap<T>> get(Class<T> type) {
        return Optional.ofNullable((ObjectToMap<T>) registry.get(Objects.requireNonNull(type, "type is a required parameter")));
    }

    public <T> MapToObjectRegistry add(Class<T> type, ObjectToMap<T> mapper) {
        registry.put(
                Objects.requireNonNull(type, "type is a required parameter"),
                Objects.requireNonNull(mapper, "mapper is a required parameter")
        );
        return this;
    }

    public boolean contains(Class<?> type) {
        return registry.containsKey(type);
    }


}
