/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.tx;

import java.util.Optional;
import java.util.function.Supplier;
import net.odoframework.container.tx.FailureAware;
import net.odoframework.container.tx.Transaction;
import net.odoframework.container.tx.TxScope;

public abstract class TxManager {
    public abstract Optional<Transaction> getActiveTransaction();

    public abstract Transaction begin();

    public <T> T doInTransaction(Class<?> type, Supplier<T> handler) {
        return this.doInTransaction(type.getName(), handler);
    }

    public <T> T doInTransaction(String name, Supplier<T> handler) {
        TxScope scope = TxScope.get(name).orElse(null);
        if (scope == null) {
            return handler.get();
        }
        Transaction tx = this.getActiveTransaction().orElse(this.begin());
        scope.getResources().forEach(tx::enlist);
        try {
            T result = handler.get();
            if (result instanceof FailureAware && ((FailureAware)result).isFailed()) {
                tx.markRollback();
            }
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            tx.markRollback();
            throw e;
        }
        finally {
            if (!tx.isMarkedRollback()) {
                tx.commit();
            } else {
                tx.rollback();
            }
        }
    }

    public abstract void commit();

    public abstract void rollback();
}

