/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.injection;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.odoframework.container.events.Log;
import net.odoframework.util.ConfigLoader;
import net.odoframework.util.EnvironmentUtils;
import net.odoframework.util.Strings;

public class ConfigurationProperties {
    public static final String ODO_PROFILE = "ODO_PROFILE";
    public static final String SYS_ODO_PROFILE = "odo.profile";
    public static final String APPLICATION_PROPERTIES = "/application.properties";
    public static final String ODO_CONFIGURATION = "odo.configuration";
    private final Properties properties = new Properties();

    public static synchronized ConfigurationProperties getGlobal(Class<?> source) {
        ConfigurationProperties configuration = (ConfigurationProperties)System.getProperties().get(ODO_CONFIGURATION);
        if (configuration == null) {
            configuration = new ConfigurationProperties();
            configuration.loadConfig(source);
            System.getProperties().put(ODO_CONFIGURATION, configuration);
        }
        return configuration;
    }

    public static synchronized void resetGlobal() {
        System.getProperties().remove(ODO_CONFIGURATION);
    }

    public synchronized Properties loadConfig(Class<?> source) {
        Properties config = this.getConfig();
        if (!config.isEmpty()) {
            return config;
        }
        Objects.requireNonNull(source.getModule());
        Properties properties = new Properties();
        String actualEnv = EnvironmentUtils.resolve((String)ODO_PROFILE, (String)SYS_ODO_PROFILE).orElse(null);
        if (Strings.isNotBlank((String)actualEnv)) {
            Log.debug(ConfigurationProperties.class, (Object)("SET ODO ENVIRONMENT TO '" + actualEnv + "'"));
            String envPropertiesFile = "/application-" + actualEnv.trim() + ".properties";
            Log.debug(ConfigurationProperties.class, (Object)("LOADING -> " + envPropertiesFile));
            config.putAll((Map<?, ?>)ConfigLoader.loadProperties((String[])new String[]{APPLICATION_PROPERTIES, envPropertiesFile}));
        } else {
            config.putAll((Map<?, ?>)ConfigLoader.loadProperties((String[])new String[]{APPLICATION_PROPERTIES}));
            Log.warn(ConfigurationProperties.class, (Object)"NO ENVIRONMENT CONFIGURED FOR ODO");
        }
        System.getenv().forEach((key, value) -> properties.put("env." + key, value));
        config.putAll((Map<?, ?>)System.getProperties());
        return this.getConfig();
    }

    public Properties getConfig() {
        return this.properties;
    }

    public void reset() {
        this.properties.clear();
    }

    public static synchronized void setConfig(Properties p) {
        System.getProperties().put(ODO_CONFIGURATION, p);
    }

    public Properties findByPrefix(String prefix, boolean stripPrefix) {
        if (this.getConfig() == null) {
            this.loadConfig(ConfigurationProperties.class);
        }
        return ConfigLoader.findByPrefix((Properties)this.getConfig(), (String)prefix, (boolean)stripPrefix);
    }
}

