/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.injection;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.odoframework.container.events.Log;
import net.odoframework.container.injection.BeanDefinition;
import net.odoframework.container.injection.Container;

public class Conditions {
    public static Predicate<Container> isBeanAlreadyPresent(String name) {
        return it -> {
            boolean check;
            Collection<BeanDefinition<?>> value = it.getDefinitions(name);
            boolean bl = check = value != null && value.size() > 1;
            if (check) {
                Log.debug(Conditions.class, (Object)(name + " is not registered in the container"));
            }
            return check;
        };
    }

    public static Predicate<Container> isBeanAlreadyPresent(Class<?> type) {
        return Conditions.isBeanAlreadyPresent(type.getName());
    }

    public static Predicate<Container> isBeanPresent(String name) {
        return it -> it.contains(name);
    }

    public static Predicate<Container> isBeanPresent(Class<?> type) {
        return Conditions.isBeanPresent(type.getName());
    }

    public static Predicate<Container> configEquals(String key, String value) {
        return it -> it.getValue(key).filter(val -> Objects.equals(val, value)).isPresent();
    }

    public static Predicate<Container> isConfigPresent(String key) {
        return it -> {
            Optional<String> value = it.getValue(key);
            if (value.isEmpty()) {
                Log.debug(Conditions.class, (Object)(key + " is not configured as a value"));
            }
            return value.isPresent();
        };
    }
}

