/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.tx;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.odoframework.container.tx.TxResource;
import net.odoframework.util.Pair;

public class TxScope {
    private static Map<String, TxScope> TX_SCOPES = new ConcurrentHashMap<String, TxScope>();
    private static ThreadLocal<Pair<String, TxScope>> SCOPE = new ThreadLocal();
    private Set<TxResource> resources = new LinkedHashSet<TxResource>();

    public static Optional<Pair<String, TxScope>> getCurrentScope() {
        return Optional.ofNullable(SCOPE.get());
    }

    public static synchronized TxScope startScope(String name) {
        TxScope scope = new TxScope();
        TX_SCOPES.put(name, scope);
        SCOPE.set((Pair<String, TxScope>)Pair.cons((Object)name, (Object)scope));
        return scope;
    }

    public static synchronized void endScope() {
        SCOPE.remove();
    }

    public static <T> T define(String name, Supplier<T> runnable) {
        TxScope scope = SCOPE.get() != null ? (TxScope)SCOPE.get().getRight() : TxScope.startScope(name);
        T result = runnable.get();
        return result;
    }

    public static void addResource(TxResource txResource) {
        TxScope.getCurrentScope().ifPresent(it -> ((TxScope)it.getRight()).add(txResource));
    }

    public static Optional<TxScope> get(String name) {
        return Optional.ofNullable(TX_SCOPES.get(name));
    }

    public void add(TxResource resource) {
        this.resources.add(resource);
    }

    public Set<TxResource> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }
}

