/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.odoframework.container.events.EventPublisher;
import net.odoframework.container.metrics.MetricEvent;
import net.odoframework.container.metrics.Metrics;
import net.odoframework.util.Timer;

public class MetricsService {
    private static Metrics METRICS = new Metrics(){

        @Override
        public <T> T doSection(String name, Supplier<T> handler) {
            AtomicReference holder = new AtomicReference();
            long timeTaken = Timer.timeTaken(() -> holder.set(handler.get()));
            EventPublisher.publish(new MetricEvent(name, name + " metric event", timeTaken));
            return (T)holder.get();
        }
    };

    public static Metrics getMetrics() {
        return METRICS;
    }

    public static void setMetrics(Metrics metrics) {
        METRICS = Objects.requireNonNull(metrics, "metrics is a required parameter");
    }
}

