/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.injection;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.odoframework.container.events.Log;
import net.odoframework.util.ConfigLoader;
import net.odoframework.util.EnvironmentUtils;
import net.odoframework.util.Strings;

public class ConfigurationProperties {
    public static final String ODO_PROFILE = "ODO_PROFILE";
    public static final String SYS_ODO_PROFILE = "odo.profile";
    public static final String APPLICATION_PROPERTIES = "/application.properties";
    public static final String ODO_CONFIGURATION = "odo.configuration";

    public static synchronized Properties loadConfig(Class<?> source) {
        Properties config = ConfigurationProperties.getConfig();
        if (config != null) {
            return config;
        }
        Objects.requireNonNull(source.getModule());
        Properties properties = new Properties();
        String actualEnv = EnvironmentUtils.resolve((String)ODO_PROFILE, (String)SYS_ODO_PROFILE).orElse(null);
        if (Strings.isNotBlank((String)actualEnv)) {
            Log.debug(ConfigurationProperties.class, (Object)("SET ODO ENVIRONMENT TO '" + actualEnv + "'"));
            String envPropertiesFile = "/application-" + actualEnv.trim() + ".properties";
            Log.debug(ConfigurationProperties.class, (Object)("LOADING -> " + envPropertiesFile));
            properties.putAll((Map<?, ?>)ConfigLoader.loadProperties((String[])new String[]{APPLICATION_PROPERTIES, envPropertiesFile}));
        } else {
            properties.putAll((Map<?, ?>)ConfigLoader.loadProperties((String[])new String[]{APPLICATION_PROPERTIES}));
            Log.warn(ConfigurationProperties.class, (Object)"NO ENVIRONMENT CONFIGURED FOR ODO");
        }
        System.getenv().forEach((key, value) -> properties.put("env." + key, value));
        properties.putAll((Map<?, ?>)System.getProperties());
        ConfigurationProperties.setConfig(properties);
        return properties;
    }

    public static Properties getConfig() {
        return (Properties)System.getProperties().get(ODO_CONFIGURATION);
    }

    public static void reset() {
        System.getProperties().remove(ODO_CONFIGURATION);
    }

    public static synchronized void setConfig(Properties p) {
        System.getProperties().put(ODO_CONFIGURATION, p);
    }

    public static Properties findByPrefix(String prefix, boolean stripPrefix) {
        if (ConfigurationProperties.getConfig() == null) {
            ConfigurationProperties.loadConfig(ConfigurationProperties.class);
        }
        return ConfigLoader.findByPrefix((Properties)ConfigurationProperties.getConfig(), (String)prefix, (boolean)stripPrefix);
    }
}

