/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.events;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.odoframework.container.events.Log;

public class EventPublisher
implements Consumer<Object> {
    private static EventPublisher EVENT_PUBLISHER = new EventPublisher();
    private ConcurrentMap<Class<?>, List<Supplier<Consumer<?>>>> eventHandlers;
    private List<Log> logBuffer = new ArrayList<Log>();

    public EventPublisher() {
        this.eventHandlers = new ConcurrentHashMap();
    }

    public static EventPublisher getInstance() {
        return EVENT_PUBLISHER;
    }

    public static void publish(Object event) {
        EventPublisher.getInstance().accept(event);
    }

    public static void handler(Class<?> eventType, Supplier<Consumer<?>> eventHandler) {
        EventPublisher.getInstance().addHandler(eventType, eventHandler);
    }

    public static void handler(Class<?> eventType, Consumer<?> eventHandler) {
        EventPublisher.getInstance().addHandler(eventType, eventHandler);
    }

    @Override
    public void accept(Object o) {
        AtomicBoolean check = new AtomicBoolean(false);
        this.eventHandlers.forEach((clazz, handler) -> {
            if (clazz.equals(o.getClass())) {
                for (Supplier consumer : handler) {
                    Consumer supplier = (Consumer)consumer.get();
                    if (o instanceof Log && !this.logBuffer.isEmpty()) {
                        List<Log> list = this.logBuffer;
                        synchronized (list) {
                            this.logBuffer.forEach(supplier::accept);
                            this.logBuffer.clear();
                        }
                    }
                    supplier.accept(o);
                    check.set(true);
                }
            }
        });
        if (o instanceof Log && !check.get()) {
            this.logBuffer.add((Log)o);
        }
    }

    public static synchronized void clearHandlers() {
        EventPublisher.EVENT_PUBLISHER.eventHandlers.clear();
    }

    public static synchronized void clearLogBuffer() {
        EVENT_PUBLISHER.clear();
    }

    private synchronized void clear() {
        this.logBuffer.clear();
    }

    public void addHandler(Class<?> eventType, Supplier<Consumer<?>> eventHandler) {
        List handlers = this.eventHandlers.computeIfAbsent(eventType, it -> new ArrayList(3));
        handlers.add(eventHandler);
    }

    public void addHandler(Class<?> eventType, Consumer<?> eventHandler) {
        this.addHandler(eventType, () -> eventHandler);
    }
}

