/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.inject.Singleton;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import net.odoframework.container.LocalDateDeserializer;
import net.odoframework.container.LocalDateTimeDeserializer;
import net.odoframework.container.LocalDateTimeSerializer;
import net.odoframework.container.util.Json;
import net.odoframework.util.Strings;

@Singleton
public class GsonJson
implements Json,
Runnable {
    private Gson gson;
    private boolean prettyPrint = true;

    public GsonJson() {
        this(true);
    }

    public GsonJson(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        GsonBuilder builder = new GsonBuilder();
        if (this.prettyPrint) {
            builder.setPrettyPrinting();
        }
        builder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer());
        builder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer());
        builder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        builder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        this.gson = builder.create();
    }

    @Override
    public String marshal(Object instance) {
        return this.gson.toJson(Objects.requireNonNull(instance, "instance is a required parameter"));
    }

    @Override
    public <T> T unmarshal(String json, Class<T> target) {
        return (T)this.gson.fromJson(Strings.requireNotBlank((String)json, (String)"json is a required parameter"), Objects.requireNonNull(target, "target is a required parameter"));
    }

    @Override
    public void run() {
        this.gson = this.prettyPrint ? new GsonBuilder().setPrettyPrinting().create() : new GsonBuilder().create();
    }
}

