/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.tx;

import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.UUID;
import net.odoframework.container.tx.Transaction;
import net.odoframework.container.tx.TxManager;

@Singleton
public class SimpleTransactionManager
extends TxManager {
    private static final ThreadLocal<Transaction> ACTIVE_TX = new ThreadLocal();

    @Override
    public Optional<Transaction> getActiveTransaction() {
        return Optional.ofNullable(ACTIVE_TX.get());
    }

    @Override
    public Transaction begin() {
        if (ACTIVE_TX.get() != null) {
            throw new IllegalStateException("Transaction already in progress");
        }
        Transaction tx = new Transaction(UUID.randomUUID().toString());
        ACTIVE_TX.set(tx);
        return tx;
    }

    @Override
    public void commit() {
        ACTIVE_TX.remove();
    }

    @Override
    public void rollback() {
        ACTIVE_TX.remove();
    }
}

