/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.sql;

import jakarta.inject.Singleton;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.odoframework.sql.SQLConnectionWrapper;
import net.odoframework.util.ConfigLoader;
import net.odoframework.util.Strings;

@Singleton
public class SimpleDataSource
implements DataSource {
    private static final Logger LOG = Logger.getLogger(SimpleDataSource.class.getName());
    static final String PREFIX = "odo.sql";
    public static final String DRIVER = "odo.sql.driver";
    public static final String URL = "odo.sql.url";
    static final String USER = "odo.sql.user";
    static final String PASSWORD = "odo.sql.password";
    static final String TIMEOUT = "odo.sql.timeout";
    private String user;
    private String password;
    private String url;
    private Connection connection;
    private PrintWriter log;
    private int timeout = 5;
    private String driver;
    private Properties properties;
    private boolean suppressClose;

    public SimpleDataSource() {
    }

    public SimpleDataSource(String user, String password, String url, int timeout, boolean suppressClose, Properties properties) {
        this.user = Objects.requireNonNull(user, "user is a required parameter");
        this.password = password;
        this.url = Objects.requireNonNull(url, "url is a required parameter");
        this.timeout = timeout;
        this.properties = properties;
        this.suppressClose = suppressClose;
    }

    public void create(String driver, String url, String user, String password, int timeout, Properties properties) {
        Strings.requireNotBlank((String)driver, (String)"driver is a required parameter for SimpleDataSource");
        Strings.requireNotBlank((String)url, (String)"url is a required parameter for SimpleDataSource");
        try {
            LOG.fine(() -> "Loading JDBC DRIVER -> " + driver);
            Class<?> driverType = Class.forName(driver);
            Driver driverInstance = (Driver)driverType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(driverInstance);
            LOG.fine(() -> "Registered JDBC DRIVER -> " + driver);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(driver + " does not exist");
        }
        LOG.fine(() -> "Using DB USER -> " + user);
        this.user = user;
        this.password = password;
        LOG.fine(() -> "Using JDBC URL -> " + url);
        this.url = Strings.requireNotBlank((String)url);
        this.timeout = timeout;
        this.driver = driver;
        LOG.fine(() -> "Setting Login Timeout to -> " + this.timeout);
        DriverManager.setLoginTimeout(this.timeout);
        this.connect(url, user, password, properties);
    }

    private void connect(String url, String user, String password, Properties properties) {
        LOG.fine(() -> "Connecting to DB....");
        this.log("Connecting to DB....");
        try {
            Properties connectionProps = properties != null ? properties : new Properties();
            connectionProps.put("user", user);
            connectionProps.put("password", password);
            Connection connection = DriverManager.getConnection(url, connectionProps);
            this.connection = new SQLConnectionWrapper(connection, this.suppressClose);
            LOG.fine(() -> "Connected!");
            this.log("Connected!");
        }
        catch (SQLException throwables) {
            String errorMessage = throwables.getErrorCode() + ":" + throwables.getMessage();
            LOG.severe(() -> errorMessage);
            this.log(errorMessage);
            throw new IllegalStateException(throwables);
        }
    }

    private void log(String errorMessage) {
        if (this.log != null) {
            this.log.println(errorMessage);
        }
    }

    public boolean isSuppressClose() {
        return this.suppressClose;
    }

    public synchronized void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Datasource is not configured call create() or init()");
        }
        if (!this.isInitialised()) {
            this.create(this.driver, this.url, this.user, this.password, this.timeout, this.properties);
        }
        return this.connection;
    }

    private boolean isConfigured() {
        return Strings.isNotBlank((String)this.driver) && Strings.isNotBlank((String)this.url);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.closeExisting();
        this.connect(this.url, username, password, this.properties);
        return this.connection;
    }

    private void closeExisting() throws SQLException {
        if (this.isInitialised()) {
            this.connection.close();
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.log = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void init(Properties config) {
        LOG.fine(() -> "Loading DB parameters");
        String driver = config.getProperty(DRIVER);
        String url = config.getProperty(URL);
        String user = config.getOrDefault((Object)USER, "").toString();
        String password = config.getOrDefault((Object)PASSWORD, "").toString();
        this.properties = ConfigLoader.findByPrefix((Properties)config, (String)PREFIX, (boolean)true);
        int timeout = Integer.parseInt(config.getOrDefault((Object)TIMEOUT, "5").toString());
        if (Strings.isBlank((String)driver)) {
            LOG.fine(() -> "No URL loaded, not loading DataSource");
            return;
        }
        this.create(driver, url, user, password, timeout, this.properties);
    }

    public void shutdown() {
        try {
            this.closeExisting();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitialised() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }
}

