/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.injection;

import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.odoframework.container.Application;
import net.odoframework.container.Module;
import net.odoframework.container.events.EventPublisher;
import net.odoframework.container.events.Log;
import net.odoframework.container.injection.BeanDefinition;
import net.odoframework.container.metrics.MetricsService;
import net.odoframework.container.tx.TxResource;
import net.odoframework.container.tx.TxScope;
import net.odoframework.util.Strings;

public class Container {
    private final Map<String, Stack<BeanDefinition<?>>> instances = new LinkedHashMap();
    private final Map<String, Object> singletons = new LinkedHashMap<String, Object>();
    private final Properties configuration;
    private Set<String> startedBeans;
    private static Container SINGLETON_CONTAINER = null;
    private static Supplier<Container> CONTAINER_SUPPLIER = null;

    public Container(Properties configuration) {
        this.configuration = Optional.ofNullable(configuration).orElse(new Properties());
        this.register(new BeanDefinition<Consumer>(EventPublisher.class.getName()).with(EventPublisher::getInstance).singleton());
    }

    public <T> Optional<T> resolve(Class<T> type) {
        return this.resolve(Objects.requireNonNull(type.getName(), "type is a required parameter"));
    }

    public <T extends Consumer<?>> Container registerEventHandler(Class<?> eventType, BeanDefinition<T> beanDefinition) {
        this.register(beanDefinition);
        this.resolve(EventPublisher.class).orElseThrow().addHandler(eventType, () -> (Consumer)this.resolve(beanDefinition.getName()).orElseThrow());
        return this;
    }

    public boolean contains(Class<?> name) {
        return this.instances.containsKey(name.getName());
    }

    public boolean contains(String name) {
        return this.instances.containsKey(name);
    }

    Collection<BeanDefinition<?>> getDefinitions(String name) {
        return this.instances.get(name);
    }

    public <T> Optional<T> resolve(String name) {
        return MetricsService.getMetrics().doSection(name, () -> {
            Stack<BeanDefinition<?>> componentList = this.instances.get(Strings.requireNotBlank((String)name, (String)"name is a required parameter"));
            if (componentList == null || componentList.empty()) {
                return Optional.empty();
            }
            BeanDefinition component = null;
            for (BeanDefinition optional : componentList) {
                if (!optional.getCondition().test(this)) continue;
                component = optional;
            }
            if (component == null) {
                return Optional.empty();
            }
            if (component.isTransactional()) {
                BeanDefinition finalComponent = component;
                try {
                    Optional<Object> optional = Optional.of(TxScope.define(component.getName(), () -> this.createInstance(name, finalComponent)));
                    return optional;
                }
                finally {
                    TxScope.endScope();
                }
            }
            return Optional.of(this.createInstance(component.getName(), component));
        });
    }

    private <T> T createInstance(String name, BeanDefinition<?> component) {
        if (this.singletons.containsKey(name)) {
            return (T)this.singletons.get(name);
        }
        Object instance = component.apply(this);
        boolean singleton = this.isSingleton(component, instance);
        if (singleton) {
            this.singletons.put(name, instance);
        }
        this.runStart(name, instance, singleton);
        if (instance instanceof TxResource) {
            TxScope.addResource((TxResource)instance);
        }
        return (T)instance;
    }

    private <T> boolean isSingleton(BeanDefinition<?> component, T instance) {
        return component.isSingleton() || instance.getClass().isAnnotationPresent(Singleton.class);
    }

    private <T> void runStart(String name, T instance, boolean isSingleton) {
        if (this.startedBeans == null) {
            this.startedBeans = new HashSet<String>();
        }
        if (instance instanceof Runnable && !this.startedBeans.contains(name)) {
            Log.debug(Container.class, (Object)("Running " + name + " as startup"));
            ((Runnable)instance).run();
            this.startedBeans.add(name);
        }
        if (instance instanceof Runnable && !isSingleton) {
            Log.trace(Container.class, (Object)("Running " + name + " as startup in prototype mode"));
            ((Runnable)instance).run();
        }
    }

    public Container register(BeanDefinition<?> beanDefinition) {
        Objects.requireNonNull(beanDefinition, "componentDefinition is a required parameter");
        Log.debug(Container.class, (Object)("Registering bean: " + Strings.requireNotBlank((String)beanDefinition.getName(), (String)"name is required on the component")));
        if (this.instances.containsKey(beanDefinition.getName())) {
            Log.warn(Container.class, (Object)("Container already contains bean: " + beanDefinition.getName()));
        } else {
            this.instances.put(beanDefinition.getName(), new Stack());
        }
        this.instances.get(beanDefinition.getName()).push(beanDefinition);
        return this;
    }

    public Optional<String> getValue(String name) {
        return Optional.ofNullable(this.configuration.getProperty(Strings.requireNotBlank((String)name, (String)"name parameter cannot be null")));
    }

    public Optional<Integer> getValueInteger(String name) {
        return Optional.ofNullable(this.configuration.getProperty(Strings.requireNotBlank((String)name, (String)"name parameter cannot be null"))).map(Integer::valueOf);
    }

    public Optional<Boolean> getValueBoolean(String name) {
        return Optional.ofNullable(this.configuration.getProperty(Strings.requireNotBlank((String)name, (String)"name parameter cannot be null"))).map(Boolean::parseBoolean);
    }

    public Optional<String> getValue(String name, String defaultValue) {
        return Optional.ofNullable(this.configuration.getProperty(Strings.requireNotBlank((String)name, (String)"name parameter cannot be null")));
    }

    private Container getContainer() {
        return this;
    }

    public <T> Provider<Optional<T>> getLazyBean(String name) {
        return () -> this.getContainer().resolve(name);
    }

    public <T> Provider<Optional<T>> getLazyBean(Class<T> type) {
        return this.getLazyBean(Objects.requireNonNull(type, "type is a required parameter").getName());
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public static void setContainerInstance(Container singletonContainer) {
        SINGLETON_CONTAINER = singletonContainer;
    }

    public static void setContainerBuilder(Supplier<Container> supplier) {
        CONTAINER_SUPPLIER = Objects.requireNonNull(supplier, "container supplier is a required parameter");
        Container.getContainerInstance();
    }

    public static synchronized Container getContainerInstance() {
        if (SINGLETON_CONTAINER == null) {
            Container lookupModule = Container.getModuleContainer();
            if (lookupModule != null) {
                SINGLETON_CONTAINER = lookupModule;
            }
            SINGLETON_CONTAINER = CONTAINER_SUPPLIER.get();
            return SINGLETON_CONTAINER;
        }
        return SINGLETON_CONTAINER;
    }

    public static synchronized Container getModuleContainer() {
        return ServiceLoader.load(Module.class).stream().filter(it -> Application.class.isAssignableFrom(it.type())).peek(it -> Log.debug(Container.class, (Object)("LOADING -> " + it.getClass().getName()))).map(ServiceLoader.Provider::get).map(it -> ((Application)it).getContainer()).findFirst().orElseThrow(() -> new IllegalStateException("Could not find an instance of " + Application.class.getName() + " via loaded modules"));
    }

    public Optional<Long> getValueLong(String value) {
        return this.getValue(value).map(Long::parseLong);
    }

    public Optional<Double> getValueDouble(String value) {
        return this.getValue(value).map(Double::parseDouble);
    }
}

