/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.injection;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import net.odoframework.container.events.Log;
import net.odoframework.util.ConfigLoader;
import net.odoframework.util.Strings;

public class ConfigurationProperties {
    public static final String ODO_PROFILE = "ODO_PROFILE";
    public static final String SYS_ODO_PROFILE = "odo.profile";
    public static final String APPLICATION_PROPERTIES = "/application.properties";
    private static Properties CONFIG;

    public static Properties loadConfig(Class<?> source) {
        String actualEnv;
        Objects.requireNonNull(source.getModule());
        String env = System.getenv().get(ODO_PROFILE);
        String sysEnv = System.getProperty(SYS_ODO_PROFILE);
        ArrayList<Object> files = new ArrayList<Object>();
        InputStream properties = null;
        try {
            Log.debug(ConfigurationProperties.class, (Object)"Loading: /application.properties");
            properties = source.getModule().getResourceAsStream(APPLICATION_PROPERTIES);
            if (properties != null) {
                Log.debug(ConfigurationProperties.class, (Object)"Loaded: /application.properties");
                files.add(APPLICATION_PROPERTIES);
            }
        }
        catch (IOException e) {
            Log.error(ConfigurationProperties.class, (Object)("/application.properties not found: " + e.getMessage()), (Throwable)e);
        }
        String string = actualEnv = Strings.isNotBlank((String)sysEnv) ? sysEnv : env;
        if (Strings.isNotBlank((String)actualEnv)) {
            Log.debug(ConfigurationProperties.class, (Object)("SET ODO ENVIRONMENT TO '" + actualEnv + "'"));
            String envPropertiesFile = "/application-" + actualEnv.trim() + ".properties";
            InputStream envProperties = null;
            try {
                envProperties = source.getModule().getResourceAsStream(envPropertiesFile);
                if (envProperties == null) {
                    throw new IllegalStateException(actualEnv + " configured but could not load " + envPropertiesFile);
                }
                Log.debug(ConfigurationProperties.class, (Object)("Loading: " + envPropertiesFile));
                files.add(envPropertiesFile);
                Log.debug(ConfigurationProperties.class, (Object)("Loaded: " + envPropertiesFile));
            }
            catch (IOException e) {
                throw new IllegalStateException(actualEnv + " configured but could not load " + envPropertiesFile, e);
            }
        } else {
            Log.warn(ConfigurationProperties.class, (Object)"NO ENVIRONMENT CONFIGURED FOR ODO");
        }
        CONFIG = ConfigLoader.loadProperties((Module)source.getModule(), (String[])files.toArray(new String[0]));
        return ConfigurationProperties.getConfig();
    }

    public static Properties getConfig() {
        return CONFIG;
    }

    public static Properties findByPrefix(String prefix, boolean stripPrefix) {
        return ConfigLoader.findByPrefix((Properties)ConfigurationProperties.getConfig(), (String)prefix, (boolean)stripPrefix);
    }
}

