/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.events;

import java.util.Objects;
import net.odoframework.container.events.EventPublisher;
import net.odoframework.container.events.TimestampEvent;
import net.odoframework.container.injection.ConfigurationProperties;

public class Log
extends TimestampEvent {
    private Level level;
    private String loggerName;
    private Object message;
    private Throwable error;

    Log(Level level, String loggerName, Object message, Throwable error) {
        this.level = level;
        this.loggerName = loggerName;
        this.message = message;
        this.error = error;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Object getMessage() {
        return this.message;
    }

    public String getMessageAsString() {
        return this.getMessage() != null ? this.getMessage().toString() : "";
    }

    public Throwable getError() {
        return this.error;
    }

    public static void trace(Class<?> logger, Object message) {
        Log.trace(logger.getName(), message);
    }

    public static void trace(String logger, Object message) {
        Log.publishLog(logger, message, Level.trace, null);
    }

    public static void debug(String logger, Object message) {
        Log.publishLog(logger, message, Level.debug, null);
    }

    public static void debug(Class<?> logger, Object message) {
        Log.debug(logger.getName(), message);
    }

    public static void info(String logger, Object message) {
        Log.publishLog(logger, message, Level.info, null);
    }

    public static void info(Class<?> logger, Object message) {
        Log.info(logger.getName(), message);
    }

    public static void warn(String logger, Object message) {
        Log.publishLog(logger, message, Level.warn, null);
    }

    public static void warn(Class<?> logger, Object message) {
        Log.warn(logger.getName(), message);
    }

    public static void error(String logger, Object message, Throwable error) {
        Log.publishLog(logger, message, Level.error, error);
    }

    public static void error(Class<?> logger, Object message, Throwable error) {
        Log.error(logger.getName(), message, error);
    }

    public static void publishLog(String logger, Object message, Level level, Throwable error) {
        EventPublisher.publish(new Log(level, Objects.requireNonNull(logger), message, error));
    }

    public static enum Level {
        trace,
        debug,
        info,
        warn,
        error,
        off;

        private String upperCaseName = this.name().toUpperCase();

        public String getUpperCaseName() {
            return this.upperCaseName;
        }

        public static Level getDefaultLevel() {
            return Level.valueOf(ConfigurationProperties.loadConfig(Log.class).getProperty("odo.logging.level", info.name()).toLowerCase());
        }
    }
}

