/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container.events;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class EventPublisher
implements Consumer<Object> {
    private static EventPublisher EVENT_PUBLISHER = new EventPublisher();
    private ConcurrentMap<Class<?>, List<Supplier<Consumer<?>>>> eventHandlers = new ConcurrentHashMap();

    @Override
    public void accept(Object o) {
        this.eventHandlers.forEach((clazz, handler) -> {
            if (clazz.equals(o.getClass())) {
                for (Supplier consumer : handler) {
                    Consumer supplier = (Consumer)consumer.get();
                    supplier.accept(o);
                }
            }
        });
    }

    public void addHandler(Class<?> eventType, Supplier<Consumer<?>> eventHandler) {
        List handlers = this.eventHandlers.computeIfAbsent(eventType, it -> new ArrayList(3));
        handlers.add(eventHandler);
    }

    public void addHandler(Class<?> eventType, Consumer<?> eventHandler) {
        this.addHandler(eventType, () -> eventHandler);
    }

    public static EventPublisher getInstance() {
        return EVENT_PUBLISHER;
    }

    public static void publish(Object event) {
        EventPublisher.getInstance().accept(event);
    }

    public static void handler(Class<?> eventType, Supplier<Consumer<?>> eventHandler) {
        EventPublisher.getInstance().addHandler(eventType, eventHandler);
    }

    public static void handler(Class<?> eventType, Consumer<?> eventHandler) {
        EventPublisher.getInstance().addHandler(eventType, eventHandler);
    }
}

