/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container;

import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import net.odoframework.container.Module;
import net.odoframework.container.injection.BeanDefinition;
import net.odoframework.container.injection.Container;
import net.odoframework.container.metrics.Metrics;
import net.odoframework.container.metrics.MetricsService;
import net.odoframework.util.Strings;

public abstract class ModuleBuilder
implements Module {
    private Container container;
    private static final Set<String> startupBeans = new LinkedHashSet<String>();

    protected ModuleBuilder register(BeanDefinition<?> beanDefinition) {
        this.container.register(beanDefinition);
        return this;
    }

    public <T> BeanDefinition<T> provides(String name) {
        BeanDefinition beanDefinition = new BeanDefinition(name);
        this.register(beanDefinition);
        return beanDefinition;
    }

    public <T> BeanDefinition<T> provides(Class<T> type) {
        BeanDefinition<T> beanDefinition = new BeanDefinition<T>(type);
        this.register(beanDefinition);
        return beanDefinition;
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public final Container apply(Container container, Properties properties) {
        this.container = container;
        this.provides(Metrics.class).with(MetricsService::getMetrics);
        this.beforeContainerPopulated(container);
        this.build();
        this.afterContainerPopulated(container);
        return this.container;
    }

    protected void beforeContainerPopulated(Container container) {
    }

    protected void afterContainerPopulated(Container container) {
    }

    public <T extends Runnable> ModuleBuilder addStartupBean(BeanDefinition<T> bean) {
        this.register(bean);
        startupBeans.add(Strings.requireNotBlank((String)bean.getName()));
        return this;
    }

    public <T extends Runnable> ModuleBuilder addStartupBean(Class<T> type) {
        this.addStartupBean(BeanDefinition.bean(type));
        startupBeans.add(type.getName());
        return this;
    }

    public abstract void build();

    public static Set<String> getStartupBeans() {
        return startupBeans;
    }
}

