/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container;

import com.google.gson.Gson;
import jakarta.inject.Singleton;
import java.util.Objects;
import net.odoframework.container.util.Json;
import net.odoframework.util.Strings;

@Singleton
public class GsonJson
implements Json,
Runnable {
    private static Gson GSON;

    @Override
    public String marshal(Object instance) {
        return GSON.toJson(Objects.requireNonNull(instance, "instance is a required parameter"));
    }

    @Override
    public <T> T unmarshal(String json, Class<T> target) {
        return (T)GSON.fromJson(Strings.requireNotBlank((String)json, (String)"json is a required parameter"), Objects.requireNonNull(target, "target is a required parameter"));
    }

    @Override
    public void run() {
        GSON = new Gson();
    }
}

