/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.container;

import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.odoframework.container.Module;
import net.odoframework.container.ModuleBuilder;
import net.odoframework.container.events.EventPublisher;
import net.odoframework.container.events.Log;
import net.odoframework.container.events.ModuleLoadedEvent;
import net.odoframework.container.injection.ConfigurationProperties;
import net.odoframework.container.injection.Container;
import net.odoframework.container.injection.ContainerFactory;

public abstract class Application
extends ModuleBuilder {
    public Application() {
        Properties config = ConfigurationProperties.loadConfig(this.getClass());
        Container container = ContainerFactory.create(config);
        this.apply(container, ConfigurationProperties.getConfig());
    }

    @Override
    protected final void beforeContainerPopulated(Container container) {
        ServiceLoader<Module> modules = ServiceLoader.load(Module.class);
        Log.debug(Application.class, (Object)("DETECTED " + modules.stream().count() + " from the System module loader"));
        List sanitizedModules = modules.stream().filter(it -> !it.type().getName().equals(this.getClass().getName())).collect(Collectors.toList());
        for (ServiceLoader.Provider moduleProvider : sanitizedModules) {
            Module module = (Module)moduleProvider.get();
            if (module.getClass().getName().equals(this.getClass().getName()) || module.getClass().getPackageName().startsWith("net.odoframework") || module.getPrecedence() >= 0) continue;
            throw new IllegalStateException("Module " + module.getClass().getName() + " odo reserves module preferences below 0");
        }
        sanitizedModules.stream().sorted(Comparator.comparing(a -> ((Module)a.get()).getPrecedence())).map(ServiceLoader.Provider::get).peek(it -> Log.debug(this.getClass(), (Object)("LOADING MODULE -> " + it.getClass().getName()))).peek(it -> it.apply(container, container.getConfiguration())).forEach(it -> EventPublisher.publish(new ModuleLoadedEvent(it.getClass().getName(), this.getClass().getName())));
    }

    @Override
    protected final void afterContainerPopulated(Container container) {
        for (String startupBean : Application.getStartupBeans()) {
            container.resolve(startupBean).map(bean -> {
                if (!(bean instanceof Runnable)) {
                    throw new IllegalStateException(startupBean + " must be an instance of Runnable to run in startup");
                }
                return bean;
            }).orElseThrow(() -> new IllegalStateException(startupBean + " does not exist but is configured to run in startup"));
        }
        this.postContainerCreated(container);
    }

    private void postContainerCreated(Container container) {
    }
}

