package net.odoframework.container.injection;

import net.odoframework.container.events.Log;
import net.odoframework.util.ConfigLoader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

import static java.util.Objects.requireNonNull;
import static net.odoframework.util.Strings.isNotBlank;

public class ConfigurationProperties {

    public static final String ODO_PROFILE = "ODO_PROFILE";
    public static final String SYS_ODO_PROFILE = "odo.profile";
    public static final String APPLICATION_PROPERTIES = "/application.properties";
    private static Properties CONFIG;



    public static Properties loadConfig(Class<?> source) {
        requireNonNull(source.getModule());
        var env = System.getenv().get(ODO_PROFILE);
        var sysEnv = System.getProperty(SYS_ODO_PROFILE);
        var files = new ArrayList<String>();
        InputStream properties = null;
        try {
            Log.debug(ConfigurationProperties.class, "Loading: " + APPLICATION_PROPERTIES);
            properties = source.getModule().getResourceAsStream(APPLICATION_PROPERTIES);
            if (properties != null) {
                Log.debug(ConfigurationProperties.class, "Loaded: " + APPLICATION_PROPERTIES);
                files.add(APPLICATION_PROPERTIES);
            }
        } catch (IOException e) {
            //do nothing
            Log.error(ConfigurationProperties.class, APPLICATION_PROPERTIES + " not found: " + e.getMessage(), e);
        }
        var actualEnv = isNotBlank(sysEnv)
                ? sysEnv
                : env;
        if (isNotBlank(actualEnv)) {
            Log.debug(ConfigurationProperties.class, "SET ODO ENVIRONMENT TO '" + actualEnv + "'");
            var envPropertiesFile = "/application-" + actualEnv.trim() + ".properties";
            InputStream envProperties = null;
            try {
                envProperties = source.getModule().getResourceAsStream(envPropertiesFile);
                if (envProperties != null) {
                    Log.debug(ConfigurationProperties.class, "Loading: " + envPropertiesFile);
                    files.add(envPropertiesFile);
                    Log.debug(ConfigurationProperties.class, "Loaded: " + envPropertiesFile);
                } else {
                    throw new IllegalStateException(actualEnv + " configured but could not load " + envPropertiesFile);
                }
            } catch (IOException e) {
                throw new IllegalStateException(actualEnv + " configured but could not load " + envPropertiesFile, e);
            }
        } else {
            Log.warn(ConfigurationProperties.class, "NO ENVIRONMENT CONFIGURED FOR ODO");
        }
        CONFIG = ConfigLoader.loadProperties(source.getModule(), files.toArray(new String[0]));
        return getConfig();
    }

    public static Properties getConfig() {
        return CONFIG;
    }


    public static Properties findByPrefix(String prefix, boolean stripPrefix) {
        return ConfigLoader.findByPrefix(getConfig(), prefix, stripPrefix);
    }


}
