package net.odoframework.container.events;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class EventPublisher implements Consumer<Object> {

    private static EventPublisher EVENT_PUBLISHER = new EventPublisher();

    private ConcurrentMap<Class<?>, List<Supplier<Consumer<?>>>> eventHandlers;


    public EventPublisher() {
        eventHandlers = new ConcurrentHashMap<>();
    }

    @Override
    @SuppressWarnings("unchecked")
    public void accept(Object o) {
        eventHandlers.forEach((clazz, handler) -> {
            if (clazz.equals(o.getClass())) {
                for (var consumer : handler) {
                    Consumer supplier = consumer.get();
                    supplier.accept(o);
                }
            }
        });
    }


    public void addHandler(Class<?> eventType, Supplier<Consumer<?>> eventHandler) {
        var handlers = eventHandlers.computeIfAbsent(eventType, it -> new ArrayList<>(3));
        handlers.add(eventHandler);
    }

    public void addHandler(Class<?> eventType, Consumer<?> eventHandler) {
        addHandler(eventType, () -> eventHandler);
    }

    public static EventPublisher getInstance() {
        return EVENT_PUBLISHER;
    }

    public static void publish(Object event) {
        getInstance().accept(event);
    }

    public static void handler(Class<?> eventType, Supplier<Consumer<?>> eventHandler) {
        getInstance().addHandler(eventType, eventHandler);
    }

    public static void handler(Class<?> eventType, Consumer<?> eventHandler) {
        getInstance().addHandler(eventType, eventHandler);
    }

}
