package net.odoframework.container;

import net.odoframework.container.injection.Container;

import java.util.function.Function;
import java.util.function.Supplier;

public interface Ref<T> extends Function<Container, Supplier<T>> {
    String getName();

    T get(Container container);

    @Override
    default Supplier<T> apply(Container container) {
        return () -> this.get(container);
    }





}
