package net.odoframework.container;

import com.google.gson.Gson;
import jakarta.inject.Singleton;
import net.odoframework.container.util.Json;
import net.odoframework.util.Strings;

import java.util.Objects;

/**
 * {@link Gson} service proder for {@link Json}
 */
@Singleton
public class GsonJson implements Json, Runnable {

    private static Gson GSON;

    @Override
    public String marshal(Object instance) {
        return GSON.toJson(Objects.requireNonNull(instance, "instance is a required parameter"));
    }

    @Override
    public <T> T unmarshal(String json, Class<T> target) {
        return GSON.fromJson(
                Strings.requireNotBlank(json, "json is a required parameter"),
                Objects.requireNonNull(target, "target is a required parameter")
        );
    }

    @Override
    public void run() {
        GSON = new Gson();
    }
}
