/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.tx;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.odoframework.container.tx.RollbackFailedException;
import org.odoframework.container.tx.TxResource;

public class Transaction {
    private final String id;
    private boolean active;
    private boolean isMarkedRollback = false;
    private Set<TxResource> txResources;

    public Transaction(String id) {
        this.id = id;
        this.active = false;
        this.txResources = new LinkedHashSet<TxResource>();
    }

    public boolean isActive() {
        return this.active;
    }

    public void enlist(TxResource txResource) {
        this.txResources.add(Objects.requireNonNull(txResource));
        txResource.begin(this);
    }

    public void commit() {
        if (this.isMarkedRollback) {
            return;
        }
        for (TxResource txResource : this.txResources) {
            txResource.commit(this);
        }
    }

    public void markRollback() {
        this.isMarkedRollback = true;
    }

    public void rollback() {
        this.isMarkedRollback = true;
        LinkedHashMap<TxResource, Exception> rollbackFailures = new LinkedHashMap<TxResource, Exception>();
        for (TxResource txResource : this.txResources) {
            try {
                txResource.rollback(this);
            }
            catch (Exception e) {
                rollbackFailures.put(txResource, e);
            }
        }
        if (!rollbackFailures.isEmpty()) {
            throw new RollbackFailedException("TRANSACTION FAILED TO ROLLBACK", rollbackFailures);
        }
    }

    public boolean isMarkedRollback() {
        return this.isMarkedRollback;
    }
}

