/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.sql;

import jakarta.inject.Singleton;
import java.sql.ResultSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.odoframework.container.metrics.Metrics;
import org.odoframework.sql.DBStatement;
import org.odoframework.sql.DefaultSQLTemplate;
import org.odoframework.sql.SQLConsumer;
import org.odoframework.sql.SQLFunction;
import org.odoframework.sql.SQLTemplate;

@Singleton
public class MonitoredDefaultSQLTemplate
extends DefaultSQLTemplate {
    private final Metrics metrics;

    public MonitoredDefaultSQLTemplate(DataSource dataSource, Metrics metrics) {
        super(dataSource);
        this.metrics = metrics;
    }

    public void execute(DBStatement sql, SQLConsumer<ResultSet> rsConsumer) {
        this.metrics.doSection(SQLTemplate.class.getSimpleName() + ".execute", () -> {
            super.execute(sql, rsConsumer);
            return null;
        });
    }

    public int execute(DBStatement sql) {
        return this.metrics.doSection(SQLTemplate.class.getSimpleName() + ".execute", () -> super.execute(sql));
    }

    public <T> Stream<T> stream(DBStatement sql, SQLFunction<ResultSet, T> row) {
        return this.metrics.doSection(SQLTemplate.class.getSimpleName() + ".stream", () -> super.stream(sql, row));
    }

    public <T> T doInTransaction(Supplier<T> supplier) {
        return (T)this.metrics.doSection(SQLTemplate.class.getSimpleName() + ".doInTransaction", () -> super.doInTransaction(supplier));
    }
}

