/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.odoframework.container.metrics.Metrics;
import org.odoframework.util.Timer;

public class MetricsService {
    private static final Logger LOG = Logger.getLogger(MetricsService.class.getName());
    private static Metrics METRICS = new Metrics(){

        @Override
        public <T> T doSection(String name, Supplier<T> handler) {
            AtomicReference holder = new AtomicReference();
            long timeTaken = Timer.timeTaken(() -> holder.set(handler.get()));
            LOG.fine(String.join((CharSequence)":", name, Long.toString(timeTaken)));
            return (T)holder.get();
        }
    };

    public static void setMetrics(Metrics metrics) {
        METRICS = Objects.requireNonNull(metrics, "metrics is a required parameter");
    }

    public static Metrics getMetrics() {
        return METRICS;
    }
}

