/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.injection;

import jakarta.inject.Provider;
import java.util.Objects;
import java.util.Optional;
import org.odoframework.container.injection.ComponentReference;
import org.odoframework.container.injection.ConfigurationReference;
import org.odoframework.container.injection.Container;
import org.odoframework.container.injection.References;
import org.odoframework.container.tx.TxManager;
import org.odoframework.util.Strings;

public class ContainerWrapper {
    private final Container container;

    public ContainerWrapper(Container container) {
        this.container = Objects.requireNonNull(container, "container is a required parameter");
    }

    public Container getContainer() {
        return this.container;
    }

    public final String value(ConfigurationReference ref) {
        return this.container.getValue(Objects.requireNonNull(ref).getName()).orElseThrow(() -> new IllegalArgumentException(ref.getName() + " is not a valid configuration property"));
    }

    public final String value(String name) {
        return this.container.getValue(Strings.requireNotBlank((String)name, (String)"name is a required parameter")).orElse(null);
    }

    public final String value(String name, String defaultValue) {
        return this.container.getValue(Strings.requireNotBlank((String)name, (String)"name is a required parameter")).orElse(defaultValue);
    }

    public final int valueAsInt(String name, int defaultValue) {
        return this.container.getValueInteger(Strings.requireNotBlank((String)name, (String)"name is a required parameter")).orElse(defaultValue);
    }

    public final long valueAsLong(String name, long defaultValue) {
        return this.container.getValueLong(Strings.requireNotBlank((String)name, (String)"name is a required parameter")).orElse(defaultValue);
    }

    public final double valueAsDouble(String name, double defaultValue) {
        return this.container.getValueDouble(Strings.requireNotBlank((String)name, (String)"name is a required parameter")).orElse(defaultValue);
    }

    public final boolean valueAsBoolean(String name, boolean defaultValue) {
        return this.container.getValueBoolean(Strings.requireNotBlank((String)name, (String)"name is a required parameter")).orElse(defaultValue);
    }

    public final <T> T references(ComponentReference<T> ref) {
        return this.container.resolve(Objects.requireNonNull(ref).getName()).orElseThrow(() -> new IllegalArgumentException(ref.getName() + " is not a valid configuration property"));
    }

    public final <T> T references(String name) {
        return this.container.resolve(Objects.requireNonNull(References.ref(name)).getName()).orElseThrow(() -> new IllegalArgumentException(name + " is not a valid registered bean"));
    }

    public final <T> T references(Class<T> type) {
        return this.references(Objects.requireNonNull(type).getName());
    }

    public <T> Provider<T> lazyReference(String name) {
        return () -> this.container.resolve(name).orElseThrow(() -> new IllegalArgumentException(name + " is not a valid registered bean"));
    }

    public <T> Provider<T> lazyReference(Class<T> type) {
        return this.lazyReference(type.getName());
    }

    public Provider<Optional<TxManager>> getLazyBean(Class<TxManager> txManagerClass) {
        return this.container.getLazyBean(txManagerClass);
    }
}

