/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.injection;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.odoframework.util.ConfigLoader;
import org.odoframework.util.Strings;

public class ConfigurationProperties {
    public static final String ODO_PROFILE = "ODO_PROFILE";
    public static final String SYS_ODO_PROFILE = "odo.profile";
    public static final String APPLICATION_PROPERTIES = "/application.properties";
    private static Properties CONFIG;
    private static final Logger LOG;

    public static Properties loadConfig(Class<?> source, String defaultProfile) {
        String actualEnv;
        Objects.requireNonNull(source.getModule());
        String env = System.getenv().get(ODO_PROFILE);
        String sysEnv = System.getProperty(SYS_ODO_PROFILE);
        ArrayList<Object> files = new ArrayList<Object>();
        InputStream properties = null;
        try {
            LOG.fine("Loading: /application.properties");
            properties = source.getModule().getResourceAsStream(APPLICATION_PROPERTIES);
            if (properties != null) {
                LOG.fine("Loaded: /application.properties");
                files.add(APPLICATION_PROPERTIES);
            }
        }
        catch (IOException e) {
            LOG.severe("/application.properties not found: " + e.getMessage());
        }
        String string = actualEnv = Strings.isNotBlank((String)sysEnv) ? sysEnv : env;
        if (Strings.isNotBlank((String)actualEnv)) {
            LOG.fine("SET ODO ENVIRONMENT TO '" + actualEnv + "'");
            String envPropertiesFile = "/application-" + actualEnv.trim() + ".properties";
            InputStream envProperties = null;
            try {
                envProperties = source.getModule().getResourceAsStream(envPropertiesFile);
                if (envProperties == null) {
                    throw new IllegalStateException(actualEnv + " configured but could not load " + envPropertiesFile);
                }
                LOG.fine("Loading: " + envPropertiesFile);
                files.add(envPropertiesFile);
                LOG.fine("Loaded: " + envPropertiesFile);
            }
            catch (IOException e) {
                throw new IllegalStateException(actualEnv + " configured but could not load " + envPropertiesFile, e);
            }
        } else {
            LOG.warning("NO ENVIRONMENT CONFIGURED FOR ODO");
        }
        CONFIG = ConfigLoader.loadProperties((Module)source.getModule(), (String[])files.toArray(new String[0]));
        return ConfigurationProperties.getConfig();
    }

    public static Properties getConfig() {
        return CONFIG;
    }

    public static Properties findByPrefix(String prefix, boolean stripPrefix) {
        return ConfigLoader.findByPrefix((Properties)ConfigurationProperties.getConfig(), (String)prefix, (boolean)stripPrefix);
    }

    static {
        LOG = Logger.getLogger(ConfigurationProperties.class.getName());
    }
}

