/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.injection;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.odoframework.container.injection.BeanDefinition;
import org.odoframework.container.injection.Container;

public class Conditions {
    private static final Logger LOG = Logger.getLogger(Conditions.class.getName());

    public static Predicate<Container> isBeanAlreadyPresent(String name) {
        return it -> {
            boolean check;
            Collection<BeanDefinition<?>> value = it.getDefinitions(name);
            boolean bl = check = value != null && value.size() > 1;
            if (check) {
                LOG.fine(name + " is not registered in the container");
            }
            return check;
        };
    }

    public static Predicate<Container> isBeanAlreadyPresent(Class<?> type) {
        return Conditions.isBeanAlreadyPresent(type.getName());
    }

    public static Predicate<Container> isBeanPresent(String name) {
        return it -> it.contains(name);
    }

    public static Predicate<Container> isBeanPresent(Class<?> type) {
        return Conditions.isBeanPresent(type.getName());
    }

    public static Predicate<Container> configEquals(String key, String value) {
        return it -> it.getValue(key).filter(val -> Objects.equals(val, value)).isPresent();
    }

    public static Predicate<Container> isConfigPresent(String key) {
        return it -> {
            Optional<String> value = it.getValue(key);
            if (value.isEmpty()) {
                LOG.fine(key + " is not configured as a value");
            }
            return value.isPresent();
        };
    }
}

