/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.odoframework.container.Ref;
import org.odoframework.container.injection.Container;
import org.odoframework.container.injection.ContainerWrapper;
import org.odoframework.container.injection.References;
import org.odoframework.util.Strings;

public class BeanDefinition<T>
implements Function<Container, T> {
    public static final Map<Class, Constructor> CACHED_CONSTRUCTORS = new HashMap<Class, Constructor>();
    private Function<ContainerWrapper, T> constructor;
    private Set<BiConsumer<ContainerWrapper, T>> initializers;
    private BiConsumer<T, ContainerWrapper> postConstruction;
    private String name;
    private boolean transactional = false;
    private Predicate<Container> condition = it -> true;
    private boolean singleton = true;

    public BeanDefinition(String name) {
        this.name = Strings.requireNotBlank((String)name, (String)"name is a required parameter");
        this.initializers = new LinkedHashSet<BiConsumer<ContainerWrapper, T>>();
    }

    public BeanDefinition(Class<T> type) {
        this(Objects.requireNonNull(type, "type is required").getName());
        if (!(type.isInterface() || type.isAnnotation() || Modifier.isAbstract(type.getModifiers()))) {
            this.constructor = this.constructorFunction(type);
        }
    }

    public BeanDefinition<T> with(Class<T> type) {
        this.constructor = this.constructorFunction(type);
        return this;
    }

    public BeanDefinition<T> with(Supplier<T> supplier) {
        this.constructor = wrapper -> supplier.get();
        return this;
    }

    public BeanDefinition<T> with(Function<ContainerWrapper, T> constructor) {
        this.constructor = Objects.requireNonNull(constructor, "constructor function is required");
        return this;
    }

    public BeanDefinition<T> initWith(BiConsumer<ContainerWrapper, T> initializer) {
        this.initializers.add(Objects.requireNonNull(initializer, "initializer is a required parameter"));
        return this;
    }

    public BeanDefinition<T> singleton() {
        this.singleton = true;
        return this;
    }

    public BeanDefinition<T> prototype() {
        this.singleton = false;
        return this;
    }

    private Function<ContainerWrapper, T> constructorFunction(Class<T> type) {
        return container -> {
            try {
                return BeanDefinition.resolveConstructor(type).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        };
    }

    private static <T> Constructor<T> resolveConstructor(Class<T> type) {
        if (!CACHED_CONSTRUCTORS.containsKey(type)) {
            try {
                CACHED_CONSTRUCTORS.put(type, type.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        return CACHED_CONSTRUCTORS.get(type);
    }

    public String getName() {
        return this.name;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public BeanDefinition<T> transactional() {
        this.transactional = true;
        return this;
    }

    public BeanDefinition<T> condition(Predicate<Container> condition) {
        this.condition = Objects.requireNonNull(condition, "condition is a required attribute");
        return this;
    }

    public <Z extends T> BeanDefinition<T> after(BiConsumer<Z, ContainerWrapper> consumer) {
        this.postConstruction = Objects.requireNonNull(consumer, "consumer is a required parameter");
        return this;
    }

    @Override
    public T apply(Container container) {
        ContainerWrapper containerWrapper = new ContainerWrapper(container);
        T instance = this.constructor.apply(containerWrapper);
        if (instance == null) {
            throw new IllegalStateException(this.getName() + " constructor returned a null object");
        }
        for (BiConsumer<ContainerWrapper, ContainerWrapper> biConsumer : this.initializers) {
            biConsumer.accept(containerWrapper, (ContainerWrapper)instance);
        }
        if (this.postConstruction != null) {
            this.postConstruction.accept(instance, containerWrapper);
        }
        return instance;
    }

    public <K> BeanDefinition<T> set(Ref<K> ref, BiConsumer<T, K> consumer) {
        this.initWith((wrapper, instance) -> {
            Object value = wrapper.references(ref.getName());
            consumer.accept(instance, value);
        });
        return this;
    }

    public <K> BeanDefinition<T> set(String name, BiConsumer<T, K> consumer) {
        return this.set(References.ref(name), consumer);
    }

    public <K> BeanDefinition<T> set(Class<K> type, BiConsumer<T, K> consumer) {
        return this.set(References.ref(type), consumer);
    }

    public static <T> BeanDefinition<T> bean(String name) {
        return new BeanDefinition<T>(name);
    }

    public static <T> BeanDefinition<T> bean(Class<T> type) {
        return new BeanDefinition<T>(type);
    }

    public Predicate<Container> getCondition() {
        return this.condition;
    }

    public BeanDefinition<T> register(Container container) {
        Objects.requireNonNull(container, "container is a required parameter").register(this);
        return this;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanDefinition)) {
            return false;
        }
        BeanDefinition that = (BeanDefinition)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

