/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container;

import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.odoframework.container.Module;
import org.odoframework.container.injection.BeanDefinition;
import org.odoframework.container.injection.Container;
import org.odoframework.container.metrics.Metrics;
import org.odoframework.container.metrics.MetricsService;
import org.odoframework.util.Strings;

public abstract class ModuleBuilder
implements Module {
    private Container container;
    private static final Set<String> startupBeans = new LinkedHashSet<String>();

    protected ModuleBuilder register(BeanDefinition<?> beanDefinition) {
        this.container.register(beanDefinition);
        return this;
    }

    public <T> BeanDefinition<T> provide(String name) {
        BeanDefinition beanDefinition = new BeanDefinition(name);
        this.register(beanDefinition);
        return beanDefinition;
    }

    public <T> BeanDefinition<T> provide(Class<T> type) {
        BeanDefinition<T> beanDefinition = new BeanDefinition<T>(type);
        this.register(beanDefinition);
        return beanDefinition;
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public final Container apply(Container container, Properties properties) {
        this.container = container;
        this.containerCreated(container);
        this.provide(Metrics.class).with(MetricsService::getMetrics);
        this.beforeContainerCreated(container);
        this.build();
        this.afterContainerCreated(container);
        return this.container;
    }

    protected void beforeContainerCreated(Container container) {
    }

    protected void afterContainerCreated(Container container) {
    }

    public ModuleBuilder addStartupBean(BeanDefinition<?> bean) {
        this.register(bean);
        startupBeans.add(Strings.requireNotBlank((String)bean.getName()));
        return this;
    }

    public ModuleBuilder addStartupBean(Class<?> type) {
        BeanDefinition<?> bean = BeanDefinition.bean(type);
        this.register(bean);
        startupBeans.add(bean.getName());
        return this;
    }

    protected void containerCreated(Container container) {
    }

    public abstract void build();

    public static Set<String> getStartupBeans() {
        return startupBeans;
    }
}

