/*
 * Decompiled with CFR 0.152.
 */
package org.odoframework.container;

import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.odoframework.container.Module;
import org.odoframework.container.ModuleBuilder;
import org.odoframework.container.injection.ConfigurationProperties;
import org.odoframework.container.injection.Container;
import org.odoframework.container.injection.ContainerFactory;

public abstract class ApplicationBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getLogger(ApplicationBuilder.class.getName());
    private static String DEFAULT_PROFILE = "dev";

    public ApplicationBuilder() {
        Properties config = ConfigurationProperties.loadConfig(this.getClass(), DEFAULT_PROFILE);
        Container container = ContainerFactory.create(config);
        this.apply(container, ConfigurationProperties.getConfig());
    }

    @Override
    protected final void containerCreated(Container container) {
    }

    @Override
    protected void beforeContainerCreated(Container container) {
        ServiceLoader<Module> modules = ServiceLoader.load(Module.class);
        LOG.fine("DETECTED " + modules.stream().count() + " from the System module loader");
        List sanitizedModules = modules.stream().filter(it -> !it.type().getName().equals(this.getClass().getName())).collect(Collectors.toList());
        for (ServiceLoader.Provider moduleProvider : sanitizedModules) {
            Module module = (Module)moduleProvider.get();
            LOG.fine("loading module " + module.getClass().getName());
            if (module.getClass().getName().equals(this.getClass().getName()) || module.getClass().getPackageName().startsWith("org.odoframework") || module.getPrecedence() >= 0) continue;
            throw new IllegalStateException("Module " + module.getClass().getName() + " odo reserves module preferences below 0");
        }
        sanitizedModules.stream().sorted(Comparator.comparing(a -> ((Module)a.get()).getPrecedence())).map(ServiceLoader.Provider::get).peek(it -> LOG.info("LOADED MODULE " + it.getClass().getName() + " from Module: " + it.getClass().getModule().getName())).forEach(it -> it.apply(container, container.getConfiguration()));
    }

    public static void setDefaultProfile(String defaultProfile) {
        DEFAULT_PROFILE = defaultProfile;
    }

    @Override
    protected final void afterContainerCreated(Container container) {
        for (String startupBean : ApplicationBuilder.getStartupBeans()) {
            container.resolve(startupBean).map(bean -> {
                if (!(bean instanceof Runnable)) {
                    throw new IllegalStateException(startupBean + " must be an instance of Runnable to run in startup");
                }
                return bean;
            }).orElseThrow(() -> new IllegalStateException(startupBean + " does not exist but is configured to run in startup"));
        }
        this.postContainerCreated(container);
    }

    private void postContainerCreated(Container container) {
    }
}

