package org.odoframework.container.util;

import java.util.Map;

public interface Json {

    String marshal(Object instance);

    <T> T unmarshal(String json, Class<T> target);

    @SuppressWarnings("unchecked")
    default Map<String, ?> unmarshalToMap(String json) {
        return unmarshal(json, Map.class);
    }

}
