package org.odoframework.container.metrics;

import org.odoframework.util.Timer;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class MetricsService {

    private static final Logger LOG = Logger.getLogger(MetricsService.class.getName());

    private static Metrics METRICS = new Metrics() {
        @Override
        public <T> T doSection(String name, Supplier<T> handler) {
            var holder = new AtomicReference<T>();
            var timeTaken = Timer.timeTaken(()-> {
                holder.set(handler.get());
            });
            LOG.fine(String.join(":", name, Long.toString(timeTaken)));
            return holder.get();
        }
    };

    public static void setMetrics(Metrics metrics) {
        METRICS = Objects.requireNonNull(metrics, "metrics is a required parameter");
    }

    public static Metrics getMetrics() {
        return METRICS;
    }


}
