package org.odoframework.container;

import com.google.gson.Gson;
import jakarta.inject.Singleton;
import org.odoframework.container.util.Json;

@Singleton
public class GsonJson implements Json, Runnable{

    private static Gson GSON;


    @Override
    public String marshal(Object instance) {
        return GSON.toJson(instance);
    }

    @Override
    public <T> T unmarshal(String json, Class<T> target) {
        return GSON.fromJson(json, target);
    }

    @Override
    public void run() {
        GSON = new Gson();
    }
}
