/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.clients.twitter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Scanner;
import net.oauth2.AccessTokenGrantRequest;
import net.oauth2.ClientCredentialsGrantRequest;
import net.oauth2.client.OAuth2ProtocolException;
import net.oauth2.client.OAuthTokenServiceDelegate;
import net.oauth2.client.SimpleTokenProvider;
import net.oauth2.client.TokenService;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.client.http.TokenServiceHttpClient;
import net.oauth2.client.http.databinding.SimpleDatabindingProvider;
import net.oauth2.client.http.javase.HttpsURLConnectionClientAdapter;

public class TwitterClient {
    public static void main(String[] args) throws OAuth2ProtocolException, IOException {
        String clientId = System.getenv().get("TWITTER_API_CLIENT_ID");
        String clientSecret = System.getenv().get("TWITTER_API_CLIENT_SECRET");
        String scopesString = System.getenv().get("TWITTER_API_SCOPES");
        if (clientId == null || clientSecret == null || scopesString == null) {
            System.out.println("* Consult with the Twitter API console to supply the parameters that will be required on the next lines.");
        }
        Scanner s = new Scanner(System.in);
        if (clientId == null) {
            System.out.print("Client ID: ");
            clientId = TwitterClient.formatString(s.nextLine());
        }
        if (scopesString == null) {
            System.out.print("API scopes (provide as single space delimited list): ");
            scopesString = TwitterClient.formatString(s.nextLine());
        }
        if (clientSecret == null) {
            System.out.print("Client Secret: ");
            clientSecret = TwitterClient.formatString(s.nextLine());
        }
        Collection<String> scopes = null;
        if (scopesString != null) {
            scopes = TwitterClient.parseScopes(scopesString);
        }
        String tokenServiceBaseUrl = "https://api.twitter.com/oauth2/";
        HttpsURLConnectionClientAdapter client = new HttpsURLConnectionClientAdapter.Builder().baseUrl(tokenServiceBaseUrl).basicAuthentication(clientId, clientSecret).mapper((DataBindingProvider)new SimpleDatabindingProvider()).build();
        ClientCredentialsGrantRequest grant = new ClientCredentialsGrantRequest(clientId, clientSecret, scopes);
        SimpleTokenProvider provider = new SimpleTokenProvider((TokenService)new OAuthTokenServiceDelegate((AccessTokenGrantRequest)grant, (TokenServiceHttpClient)client));
        System.out.println(provider.get());
        s.close();
    }

    static Collection<String> parseScopes(String scopesString) {
        String[] enumerationArr = scopesString.split("\\s+");
        Collection<String> list = Collections.unmodifiableCollection(Arrays.asList(enumerationArr));
        return list;
    }

    static String formatString(String val) {
        return val == null ? "" : val;
    }
}

