/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.clients.google;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Scanner;
import net.oauth2.AccessTokenGrantRequest;
import net.oauth2.AuthorizationCodeGrantRequest;
import net.oauth2.client.OAuth2ProtocolException;
import net.oauth2.client.OAuthTokenServiceDelegate;
import net.oauth2.client.SimpleTokenProvider;
import net.oauth2.client.TokenService;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.client.http.TokenServiceHttpClient;
import net.oauth2.client.http.databinding.SimpleDatabindingProvider;
import net.oauth2.client.http.javase.HttpsURLConnectionClientAdapter;

public class GoogleClient {
    public static void main(String[] args) throws OAuth2ProtocolException, IOException {
        String clientId = System.getenv().get("GOOGLE_API_CLIENT_ID");
        String clientSecret = System.getenv().get("GOOGLE_API_CLIENT_SECRET");
        String scopesString = System.getenv().get("GOOGLE_API_SCOPES");
        String redirectUri = System.getenv().get("GOOGLE_API_REDIRECT_URI");
        String code = System.getenv().get("GOOGLE_API_AUTHORIZATION_CODE");
        if (code == null || clientId == null || clientSecret == null || scopesString == null) {
            System.out.println("* Consult with the Google API console to supply the parameters that will be required on the next lines.");
        }
        Scanner s = new Scanner(System.in);
        if (clientId == null) {
            System.out.print("Client ID: ");
            clientId = GoogleClient.formatString(s.nextLine());
        }
        if (redirectUri == null) {
            System.out.print("Redirect URI: ");
            redirectUri = GoogleClient.formatString(s.nextLine());
        }
        if (scopesString == null) {
            System.out.print("API scopes (provide as single space delimited list): ");
            scopesString = GoogleClient.formatString(s.nextLine());
        }
        if (code == null) {
            String authCodeRequest = MessageFormat.format("https://accounts.google.com/o/oauth2/v2/auth?response_type=code&client_id={0}&redirect_uri={1}&scope={2}", clientId, redirectUri, scopesString);
            System.out.println("Copy this request to a browser, provide consent when asked and finally copy the value of \"code\" request parameter from the redirect url. The code will be required.");
            System.out.println(authCodeRequest);
            System.out.print("Authorization code: ");
            code = s.nextLine();
        }
        if (clientSecret == null) {
            System.out.print("Client Secret: ");
            clientSecret = GoogleClient.formatString(s.nextLine());
        }
        Collection<String> scopes = null;
        if (scopesString != null) {
            scopes = GoogleClient.parseScopes(scopesString);
        }
        String tokenServiceBaseUrl = "https://www.googleapis.com/oauth2/v4/";
        HttpsURLConnectionClientAdapter client = new HttpsURLConnectionClientAdapter.Builder().baseUrl(tokenServiceBaseUrl).basicAuthentication(clientId, clientSecret).mapper((DataBindingProvider)new SimpleDatabindingProvider()).build();
        AuthorizationCodeGrantRequest grant = new AuthorizationCodeGrantRequest(code, clientId, clientSecret, redirectUri, scopes);
        SimpleTokenProvider provider = new SimpleTokenProvider((TokenService)new OAuthTokenServiceDelegate((AccessTokenGrantRequest)grant, (TokenServiceHttpClient)client));
        System.out.println(provider.get());
        s.close();
    }

    static Collection<String> parseScopes(String scopesString) {
        String[] enumerationArr = scopesString.split("\\s+");
        Collection<String> list = Collections.unmodifiableCollection(Arrays.asList(enumerationArr));
        return list;
    }

    static String formatString(String val) {
        return val == null ? "" : val;
    }
}

