/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.clients.github;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Scanner;
import net.oauth2.AccessTokenGrantRequest;
import net.oauth2.AuthorizationCodeGrantRequest;
import net.oauth2.client.OAuth2ProtocolException;
import net.oauth2.client.OAuthTokenServiceDelegate;
import net.oauth2.client.SimpleTokenProvider;
import net.oauth2.client.TokenService;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.client.http.TokenServiceHttpClient;
import net.oauth2.client.http.javase.HttpsURLConnectionClientAdapter;
import net.oauth2.clients.github.GithubDatabindingProvider;

public class GithubClient {
    public static void main(String[] args) throws OAuth2ProtocolException, IOException {
        String clientId = System.getenv().get("GITHUB_API_CLIENT_ID");
        String clientSecret = System.getenv().get("GITHUB_API_CLIENT_SECRET");
        String scopesString = System.getenv().get("GITHUB_API_SCOPES");
        String redirectUri = System.getenv().get("GITHUB_API_REDIRECT_URI");
        String code = System.getenv().get("GITHUB_API_AUTHORIZATION_CODE");
        if (code == null || clientId == null || clientSecret == null || scopesString == null) {
            System.out.println("* Consult with the Google API console to supply the parameters that will be required on the next lines.");
        }
        Scanner s = new Scanner(System.in);
        if (clientId == null) {
            System.out.print("Client ID: ");
            clientId = GithubClient.formatString(s.nextLine());
        }
        if (redirectUri == null) {
            System.out.print("Redirect URI: ");
            redirectUri = GithubClient.formatString(s.nextLine());
        }
        if (scopesString == null) {
            System.out.print("API scopes (provide as single space delimited list): ");
            scopesString = GithubClient.formatString(s.nextLine());
        }
        if (code == null) {
            String authCodeRequest = MessageFormat.format("http://github.com/login/oauth/authorize?client_id={0}&redirect_uri={1}&scope={2}", clientId, redirectUri, scopesString);
            System.out.println("Copy this request to a browser, provide consent when asked and finally copy the value of \"code\" request parameter from the redirect url. The code will be required.");
            System.out.println();
            System.out.println(authCodeRequest);
            System.out.println();
            System.out.print("Authorization code: ");
            code = s.nextLine();
        }
        if (clientSecret == null) {
            System.out.print("Client Secret: ");
            clientSecret = GithubClient.formatString(s.nextLine());
        }
        Collection<String> scopes = null;
        if (scopesString != null) {
            scopes = GithubClient.parseScopes(scopesString);
        }
        String tokenServiceBaseUrl = "https://github.com/login/oauth/";
        HttpsURLConnectionClientAdapter client = new HttpsURLConnectionClientAdapter.Builder().baseUrl(tokenServiceBaseUrl).basicAuthentication(clientId, clientSecret).mapper((DataBindingProvider)new GithubDatabindingProvider()).build();
        AuthorizationCodeGrantRequest grant = new AuthorizationCodeGrantRequest(code, clientId, clientSecret, redirectUri, scopes);
        SimpleTokenProvider provider = new SimpleTokenProvider((TokenService)new OAuthTokenServiceDelegate((AccessTokenGrantRequest)grant, (TokenServiceHttpClient)client, "access_token"));
        System.out.println(provider.get());
        s.close();
    }

    static Collection<String> parseScopes(String scopesString) {
        String[] enumerationArr = scopesString.split("\\s+");
        Collection<String> list = Collections.unmodifiableCollection(Arrays.asList(enumerationArr));
        return list;
    }

    static String formatString(String val) {
        return val == null ? "" : val;
    }
}

