/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import net.oauth2.AccessToken;
import net.oauth2.ProtocolError;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.gson.AccessTokenTypeAdapter;
import net.oauth2.gson.ProtocolErrorTypeAdapter;
import net.oauth2.gson.WhitespaceDelimitedCollectionTypeAdapterFactory;

public class GsonDataBindingProvider
implements DataBindingProvider<Gson> {
    public static GsonBuilder DEFAULT_BUILDER;
    private static final Gson DEFAULT_MAPPER;
    private Gson mapper;

    public GsonDataBindingProvider() {
        this(DEFAULT_MAPPER);
    }

    public GsonDataBindingProvider(GsonBuilder builder) {
        this(builder.create());
    }

    public GsonDataBindingProvider(Gson mapper) {
        this.mapper = mapper;
    }

    public <T extends AccessToken> T parseToken(String payload, Class<T> tokenType) throws JsonParseException, IOException {
        AccessToken token = (AccessToken)this.mapper.fromJson(payload, tokenType);
        return (T)token;
    }

    public <T extends ProtocolError> T parseError(String payload, Class<T> errorType) throws JsonParseException, IOException {
        ProtocolError error = (ProtocolError)this.mapper.fromJson(payload, errorType);
        return (T)error;
    }

    public Gson raw() {
        return this.mapper;
    }

    public void with(Gson mapper) {
        this.mapper = mapper;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        WhitespaceDelimitedCollectionTypeAdapterFactory.REGISTER(builder);
        AccessTokenTypeAdapter.REGISTER(builder);
        ProtocolErrorTypeAdapter.REGISTER(builder);
        DEFAULT_BUILDER = builder;
        DEFAULT_MAPPER = DEFAULT_BUILDER.create();
    }
}

