/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WhitespaceDelimitedCollectionTypeAdapterFactory<C extends Collection<String>>
implements TypeAdapterFactory {
    private final Class<?> customizedClass;
    private static final String SP = " ";

    public WhitespaceDelimitedCollectionTypeAdapterFactory(Class<?> customizedClassType) {
        this.customizedClass = customizedClassType;
    }

    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        return type.getRawType() == this.customizedClass || this.customizedClass.isAssignableFrom(type.getRawType()) ? this.customizeTypeAdapter(gson, type) : null;
    }

    private TypeAdapter<C> customizeTypeAdapter(Gson gson, TypeToken<C> type) {
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
        return new TypeAdapter<C>(){

            public void write(JsonWriter out, C value) throws IOException {
                JsonElement tree = delegate.toJsonTree(value);
                if (WhitespaceDelimitedCollectionTypeAdapterFactory.this.beforeWrite(value, tree, out)) {
                    elementAdapter.write(out, (Object)tree);
                }
            }

            public C read(JsonReader in) throws IOException {
                JsonElement tree = (JsonElement)elementAdapter.read(in);
                String enumerationStr = tree.getAsString();
                String[] enumerationArr = enumerationStr.split("\\s+");
                List<String> collection = Collections.unmodifiableList(Arrays.asList(enumerationArr));
                WhitespaceDelimitedCollectionTypeAdapterFactory.this.afterRead(tree, collection);
                return collection;
            }
        };
    }

    protected boolean beforeWrite(C source, JsonElement toSerialize, JsonWriter out) {
        StringBuilder scopesBuilder = new StringBuilder();
        source.stream().forEach(e -> scopesBuilder.append((String)e).append(SP));
        String scopeString = scopesBuilder.toString();
        scopeString = scopeString.trim();
        try {
            out.value(scopeString);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return false;
    }

    protected void afterRead(JsonElement deserialized, C collection) {
    }

    public static GsonBuilder REGISTER(GsonBuilder builder) {
        return builder.registerTypeAdapterFactory(new WhitespaceDelimitedCollectionTypeAdapterFactory(Collection.class));
    }
}

