/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.client.http.okhttp3;

import java.io.IOException;
import net.oauth2.AccessToken;
import net.oauth2.client.TokenProvider;
import net.oauth2.client.http.ResourceOAuthHeader;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OAuthResourceRequestInterceptor<T extends AccessToken>
implements Interceptor {
    TokenProvider tokenProvider;

    public OAuthResourceRequestInterceptor(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        AccessToken token = this.tokenProvider.get();
        if (token != null) {
            String headerValue = ResourceOAuthHeader.format((AccessToken)token);
            request = chain.request().newBuilder().addHeader("Authorization", headerValue).build();
        }
        return chain.proceed(request);
    }
}

