/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.client.http.okhttp3;

import commons.http.WwwFormUrlEncodedCodec;
import java.io.IOException;
import net.oauth2.AccessToken;
import net.oauth2.AccessTokenGrantRequest;
import net.oauth2.ParametersMap;
import net.oauth2.ProtocolError;
import net.oauth2.RefreshTokenGrantRequest;
import net.oauth2.client.OAuth2ProtocolException;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.client.http.FormEncodeDataBinding;
import net.oauth2.client.http.TokenServiceHttpClient;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientAdapter<T extends AccessToken>
implements TokenServiceHttpClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OkHttpClientAdapter.class);
    protected String serviceBaseUrl;
    protected RefreshTokenGrantRequest refreshTokenGrantRequest;
    protected OkHttpClient okHttpClient;
    private DataBindingProvider<?> dataBindingProvider;
    private Class<T> accessTokenClass;
    private static final FormEncodeDataBinding grantRequestFormEncoder = new FormEncodeDataBinding().with("scope", (WwwFormUrlEncodedCodec.Serializer)new FormEncodeDataBinding.CollectionSerializer());
    public static final MediaType WWW_FORM_ENCODED = MediaType.parse((String)"application/x-www-form-encoded");
    public static final MediaType JSON = MediaType.parse((String)"*/json");

    public OkHttpClientAdapter(String serviceBaseUrl, OkHttpClient httpClient, DataBindingProvider<?> dataBindingProvider, Class<T> accessTokenClass) {
        if (serviceBaseUrl == null) {
            throw new IllegalArgumentException("serviceBaseUrl is null");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient is null");
        }
        this.serviceBaseUrl = serviceBaseUrl;
        this.okHttpClient = httpClient;
        this.dataBindingProvider = dataBindingProvider;
        if (accessTokenClass == null) {
            accessTokenClass = AccessToken.class;
        }
        this.accessTokenClass = accessTokenClass;
    }

    public T post(String urlPath, AccessTokenGrantRequest grantRequest) throws IOException {
        if (urlPath == null) {
            urlPath = "token";
        }
        String requestUrl = String.format("%s%s", this.serviceBaseUrl, urlPath);
        String payload = grantRequestFormEncoder.encode((ParametersMap)grantRequest, null);
        RequestBody body = RequestBody.create((MediaType)WWW_FORM_ENCODED, (String)payload);
        Request request = new Request.Builder().url(requestUrl).post(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        AccessToken token = null;
        if (response.isSuccessful()) {
            String responsePayload = response.body().string();
            token = this.dataBindingProvider.parseToken(responsePayload, this.accessTokenClass);
        } else {
            this.handleProtocolError(response, "");
        }
        return (T)token;
    }

    protected void handleProtocolError(Response response, String operationName) throws IOException {
        ProtocolError error = null;
        String errorMsg = "Access Token post request failed";
        IOException ex = null;
        String responseContentTypeSubtype = null;
        String contentTypeHeaderValue = response.header("Content-Type");
        if (contentTypeHeaderValue != null) {
            responseContentTypeSubtype = MediaType.parse((String)response.header("Content-Type")).subtype();
        }
        if (response.code() > 399 && responseContentTypeSubtype != null && responseContentTypeSubtype.equals(JSON.subtype())) {
            String responseString = response.body().string();
            error = this.dataBindingProvider.parseError(responseString, ProtocolError.class);
            ex = new OAuth2ProtocolException(error);
            errorMsg = String.format("%s. [%s]: %s", errorMsg, error.getError(), error.getDescription());
        } else {
            ex = new IOException(errorMsg);
        }
        LOGGER.error(errorMsg);
        throw ex;
    }
}

