/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.client.http.javase.conn;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpLoggingFormatter {
    private static final String NEWLINE = System.getProperty("line.separator");

    public String formatRequest(HttpsURLConnection connection, String requestPayload) {
        StringBuilder log = new StringBuilder();
        log.append("--> ");
        String requestLine = connection.getRequestMethod() + " " + connection.getURL().toString();
        log.append(requestLine);
        log.append(NEWLINE);
        String requestHeaders = this.headers(connection.getRequestProperties());
        log.append(requestHeaders);
        log.append(NEWLINE);
        if (requestPayload != null && requestPayload.trim().length() > 0) {
            log.append(requestPayload);
        }
        return log.toString();
    }

    public String formatResponse(HttpsURLConnection connection, String responsePayload, String errorDetails) {
        StringBuilder log = new StringBuilder();
        log.append("<-- ");
        String responseStatusLine = this.getStatusLine(connection);
        log.append(responseStatusLine);
        log.append(NEWLINE);
        String responseHeaders = this.headers(connection.getHeaderFields());
        log.append(responseHeaders);
        log.append(NEWLINE);
        if (responsePayload != null && responsePayload.trim().length() > 0) {
            log.append(responsePayload);
            log.append(NEWLINE);
        }
        if (errorDetails != null && errorDetails.trim().length() > 0) {
            log.append(errorDetails);
            log.append(NEWLINE);
        }
        return log.toString();
    }

    private String headers(Map<String, List<String>> headers) {
        StringBuilder headersList = new StringBuilder();
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (header.getKey() == null || header.getValue() == null) continue;
            headersList.append(header.getKey()).append(":").append(header.getValue().toString()).append(NEWLINE);
        }
        return headersList.toString();
    }

    private String getStatusLine(HttpURLConnection connection) {
        List<String> statusLineList;
        String responseStatusLine = null;
        if (connection.getHeaderFields() != null && connection.getHeaderFields().get(null) != null && (statusLineList = connection.getHeaderFields().get(null)).size() > 0) {
            responseStatusLine = statusLineList.get(0);
        }
        if (responseStatusLine == null) {
            try {
                responseStatusLine = "HTTP/1.0 " + connection.getResponseCode() + " " + connection.getResponseMessage();
            }
            catch (IOException e) {
                responseStatusLine = "Cannot retrieve status line from this connection reponse";
            }
        }
        return responseStatusLine;
    }
}

