/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.client.http.apache.httpcomponents;

import java.io.IOException;
import net.oauth2.AccessToken;
import net.oauth2.client.TokenProvider;
import net.oauth2.client.http.ResourceOAuthHeader;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class OAuthResourceRequestInterceptor<T extends AccessToken>
implements HttpRequestInterceptor {
    TokenProvider tokenProvider;

    public OAuthResourceRequestInterceptor(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AccessToken token = this.tokenProvider.get();
        String headerValue = ResourceOAuthHeader.format((AccessToken)token);
        request.addHeader("Authorization", headerValue);
    }
}

