/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.client.http.apache.httpcomponents;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.oauth2.AccessToken;
import net.oauth2.AccessTokenGrantRequest;
import net.oauth2.ProtocolError;
import net.oauth2.client.OAuth2ProtocolException;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.client.http.FormEncodeDataBinding;
import net.oauth2.client.http.TokenServiceHttpClient;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientAdapter
implements TokenServiceHttpClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApacheHttpClientAdapter.class);
    private URL baseUrl;
    private CloseableHttpClient httpclient;
    private DataBindingProvider<?> dataBindingProvider;
    private Class tokenClass;

    public <T extends AccessToken> ApacheHttpClientAdapter(URL baseUrl, String username, String password, DataBindingProvider<?> dataBindingProvider, Class<T> tokenClass) {
        this.baseUrl = baseUrl;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        this.httpclient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        this.dataBindingProvider = dataBindingProvider;
        if (tokenClass == null) {
            tokenClass = AccessToken.class;
        }
        this.tokenClass = tokenClass;
    }

    public <T extends AccessToken> T post(String urlPath, AccessTokenGrantRequest grantRequest) throws IOException {
        URL url = null;
        url = urlPath != null ? new URL(this.baseUrl, urlPath) : this.baseUrl;
        List<NameValuePair> formPayload = ApacheHttpClientAdapter.formEncodeGrant(grantRequest);
        String responsePayload = this.httpPostForm(url, formPayload);
        AccessToken token = this.dataBindingProvider.parseToken(responsePayload, this.tokenClass);
        return (T)token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPostForm(URL url, List<NameValuePair> formPayload) throws IOException, OAuth2ProtocolException {
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formPayload, Consts.UTF_8);
        HttpPost httpPostMethod = new HttpPost(url.toExternalForm());
        httpPostMethod.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpPostMethod);
        String responsePayload = null;
        try {
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                long len = responseEntity.getContentLength();
                if (len != -1L && len < 2048L) {
                    responsePayload = EntityUtils.toString((HttpEntity)responseEntity);
                }
                if (response.getStatusLine().getStatusCode() > 399) {
                    this.handleProtocolError((HttpResponse)response, responsePayload);
                }
            }
        }
        finally {
            if (response instanceof CloseableHttpResponse) {
                response.close();
            }
        }
        return responsePayload;
    }

    private static List<NameValuePair> formEncodeGrant(AccessTokenGrantRequest grant) {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        try {
            grant.map().entrySet().stream().forEach(e -> {
                String key = (String)e.getKey();
                String val = null;
                if (e.getValue() != null) {
                    if (String.class.isAssignableFrom(e.getValue().getClass())) {
                        val = (String)e.getValue();
                    } else if (key == "scope") {
                        Collection scopes = (Collection)e.getValue();
                        val = FormEncodeDataBinding.CollectionSerializer.formatToDelimitedString((Collection)scopes);
                    } else {
                        throw new RuntimeException("Unsupported type for form encoding: " + e.getValue().getClass());
                    }
                    try {
                        if (val != null) {
                            val = URLEncoder.encode(val, StandardCharsets.UTF_8.name());
                            formparams.add((NameValuePair)new BasicNameValuePair(key, val));
                        }
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new RuntimeException(uee);
                    }
                }
            });
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Cannot encode this AccessTokenGrantRequest to application/x-www-form-urlencoded string", e2);
        }
        return formparams;
    }

    private void handleProtocolError(HttpResponse response, String responsePayload) throws IOException {
        int idx;
        String errorMsg = "Token post request failed";
        String contentTypeString = null;
        if (response.containsHeader("Content-Type") && (idx = (contentTypeString = response.getFirstHeader("Content-Type").getValue()).indexOf(";")) > -1) {
            contentTypeString = contentTypeString.substring(0, idx);
        }
        IOException ex = null;
        if (responsePayload == null || responsePayload.length() < 1 || contentTypeString == null || !"application/json".equals(contentTypeString)) {
            ex = new IOException(errorMsg);
        } else if (contentTypeString != null && responsePayload != null) {
            String subtype = contentTypeString.substring(contentTypeString.indexOf("/") + 1, contentTypeString.length());
            if (subtype.startsWith("json")) {
                ProtocolError error = this.dataBindingProvider.parseError(responsePayload, ProtocolError.class);
                ex = new OAuth2ProtocolException(error);
                errorMsg = String.format("%s. [%s]: %s", errorMsg, error.getError(), error.getDescription());
            } else {
                errorMsg = responsePayload;
            }
        }
        if (ex == null) {
            ex = new IOException(errorMsg);
        }
        LOGGER.error(errorMsg);
        throw ex;
    }
}

