/*
 * Decompiled with CFR 0.152.
 */
package net.nilosplace.process_display;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessDisplayHelper {
    private static final Logger log = LogManager.getLogger(ProcessDisplayHelper.class);
    private Runtime runtime = Runtime.getRuntime();
    private DecimalFormat df = new DecimalFormat("#");
    private long startTime = 0L;
    private long lastTime = 0L;
    private String message;
    private long lastSizeCounter = 0L;
    private long totalSize;
    private final Semaphore sem = new Semaphore(1);
    private AtomicLong sizeCounter = new AtomicLong(0L);
    private long displayTimeout = 30000L;

    public ProcessDisplayHelper() {
    }

    public ProcessDisplayHelper(Integer displayTimeout) {
        this.displayTimeout = displayTimeout.intValue();
    }

    public void startProcess() {
        this.startProcess("", 0L);
    }

    public void startProcess(String message) {
        this.startProcess(message, 0L);
    }

    public void startProcess(String message, long totalSize) {
        this.message = message + ": ";
        this.totalSize = totalSize;
        this.lastSizeCounter = 0L;
        this.startTime = new Date().getTime();
        this.sizeCounter = new AtomicLong(0L);
        if (totalSize > 0L) {
            this.logInfoMessage(this.message + "Starting Process [total = " + ProcessDisplayHelper.getBigNumber(totalSize) + "] " + new Date());
        } else {
            this.logInfoMessage(this.message + "Starting Process... (" + new Date() + ")");
        }
        this.lastTime = new Date().getTime();
    }

    public void progressProcess() {
        this.progressProcess(null, 1L);
    }

    public void progressProcess(String data) {
        this.progressProcess(data, 1L);
    }

    public void progressProcess(Long amount) {
        this.progressProcess(null, amount);
    }

    public void progressProcess(String data, long amount) {
        this.sizeCounter.getAndAdd(amount);
        boolean permit = this.sem.tryAcquire();
        if (permit) {
            Date now = new Date();
            long nowLong = now.getTime();
            long time = nowLong - this.lastTime;
            if (time < this.displayTimeout) {
                this.sem.release();
                return;
            }
            long diff = nowLong - this.startTime;
            this.checkMemory();
            double percent = 0.0;
            if (this.totalSize > 0L) {
                percent = (double)this.sizeCounter.get() / (double)this.totalSize;
            }
            long processedAmount = this.sizeCounter.get() - this.lastSizeCounter;
            StringBuffer sb = new StringBuffer(this.message);
            sb.append(ProcessDisplayHelper.getBigNumber(this.sizeCounter.get()));
            if (this.totalSize > 0L) {
                sb.append(" of [" + ProcessDisplayHelper.getBigNumber(this.totalSize) + "] " + (int)(percent * 100.0) + "%");
            }
            sb.append(", " + time / 1000L + "s to process " + ProcessDisplayHelper.getBigNumber(processedAmount) + " records at " + ProcessDisplayHelper.getBigNumber(processedAmount * 1000L / time) + "r/s");
            if (data != null) {
                sb.append(" " + data);
            }
            if (percent > 0.0) {
                int perms = (int)((double)diff / percent);
                Date end = new Date(this.startTime + (long)perms);
                String expectedDuration = ProcessDisplayHelper.getHumanReadableTimeDisplay(end.getTime() - nowLong);
                sb.append(", Mem: " + this.df.format(this.memoryPercent() * 100.0) + "%, ETA: " + expectedDuration + " [" + end + "]");
            }
            this.logInfoMessage(sb.toString());
            this.lastSizeCounter = this.sizeCounter.get();
            this.lastTime = nowLong;
            this.sem.release();
        }
    }

    public void finishProcess() {
        this.finishProcess(null);
    }

    public void finishProcess(String data) {
        Date now = new Date();
        long duration = now.getTime() - this.startTime;
        String result = ProcessDisplayHelper.getHumanReadableTimeDisplay(duration);
        String localMessage = this.message + "Finished: took: " + result + " to process " + ProcessDisplayHelper.getBigNumber(this.sizeCounter.get());
        localMessage = duration != 0L ? localMessage + " records at a rate of: " + ProcessDisplayHelper.getBigNumber(this.sizeCounter.get() * 1000L / duration) + "r/s " + ProcessDisplayHelper.getBigNumber(this.sizeCounter.get() * 60000L / duration) + "r/m" : localMessage + " records";
        if (data != null) {
            localMessage = localMessage + " " + data;
        }
        this.logInfoMessage(localMessage);
    }

    private static String getBigNumber(long number) {
        return String.format("%,d", number);
    }

    public static String getHumanReadableTimeDisplay(long duration) {
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void checkMemory() {
        if (this.memoryPercent() > 0.95) {
            this.logWarnMessage(this.message + "Memory Warning: " + this.df.format(this.memoryPercent() * 100.0) + "%");
            this.logWarnMessage(this.message + "Used Mem: " + (this.runtime.totalMemory() - this.runtime.freeMemory()));
            this.logWarnMessage(this.message + "Free Mem: " + this.runtime.freeMemory());
            this.logWarnMessage(this.message + "Total Mem: " + this.runtime.totalMemory());
            this.logWarnMessage(this.message + "Max Memory: " + this.runtime.maxMemory());
        }
    }

    private double memoryPercent() {
        return ((double)this.runtime.totalMemory() - (double)this.runtime.freeMemory()) / (double)this.runtime.maxMemory();
    }

    private void logWarnMessage(String message) {
        log.warn(message);
    }

    private void logInfoMessage(String message) {
        log.info(message);
    }
}

