/*
 * Decompiled with CFR 0.152.
 */
package net.nilosplace.exception_catcher;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.nilosplace.exception_catcher.ExceptionSink;

public class ExceptionDispatcher {
    private static final List<ExceptionSink> sinks = new CopyOnWriteArrayList<ExceptionSink>();

    public static void registerSinks(ExceptionSink ... newSinks) {
        sinks.addAll(Arrays.asList(newSinks));
    }

    public static void dispatch(Throwable t) {
        for (ExceptionSink sink : sinks) {
            try {
                sink.handle(t);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

