/*
 * Decompiled with CFR 0.152.
 */
package net.nilosplace.exception_catcher;

import net.nilosplace.exception_catcher.ExceptionDispatcher;
import net.nilosplace.exception_catcher.ExceptionSink;

public class ExceptionCatcher {
    public static void initialize(ExceptionSink ... sinks) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> ExceptionCatcher.handleException(e));
        Thread.currentThread().setUncaughtExceptionHandler((t, e) -> ExceptionCatcher.handleException(e));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {}));
        ExceptionDispatcher.registerSinks(sinks);
    }

    private static void handleException(Throwable e) {
        ExceptionDispatcher.dispatch(e);
    }
}

