package net.nilosplace.exception_catcher;

public class ExceptionCatcher {

	public static void initialize(ExceptionSink... sinks) {
		Thread.setDefaultUncaughtExceptionHandler((t, e) -> handleException(e));
		Thread.currentThread().setUncaughtExceptionHandler((t, e) -> handleException(e));

		Runtime.getRuntime().addShutdownHook(new Thread(() -> {
			// Cleanup if needed
		}));

		ExceptionDispatcher.registerSinks(sinks);
	}

	private static void handleException(Throwable e) {
		ExceptionDispatcher.dispatch(e);
	}

}
